clear all
close all
clc



 clear all
close all
clc


% global coupling parameter values used in manuscript.
for WE = [1.5,2.05,2.115,2.25]
% other parameters 
theta = 1;
p = 0.2;
a = 5;
tau1 = 1;
tau2 = 5;
T = 1*10^3; 
N = 100;
%Erdos Renyi 

WEE = rand(N,N); 
for i = 1:N 
WEE(i,:) = WE*WEE(i,:)/sum(WEE(i,:));
end



%% integrate and save results
options = odeset('AbsTol',1e-14,'RelTol',1e-14);
int = rand(3*N,1);
tic
[t,y] = ode45(@(t,y) WC(WEE,tau1,tau2,p,a,theta,N,y),0:0.1:T,int,options); 
[t,y] = ode45(@(t,y) WC(WEE,tau1,tau2,p,a,theta,N,y),0:0.1:T,y(end,:)',options); 
toc
save(sprintf('ER_sim_WE=%3.3f.mat',WE));


%% plot 
figure
title(sprintf('WE=%3.3f.mat',WE))
subplot(1,2,1)
plot(y(:,1:10),y(:,N+1:N+10))
xlabel('E')
ylabel('I')
subplot(1,2,2)
plot(t,y(:,1:N))
xlabel('t')
ylabel('E(t)')
xlim([0,1000])
end